numHandsMax = 120000;
numPlayers=[1,2,4,8,12];
numPlayersMax=12;
time=zeros(numPlayersMax);
fprintf('Simulating %d hands of blackjack.\n', numHandsMax);
matlabpool open local 
for j=1:5;
    tic;
    numHands=numHandsMax/numPlayers(j);
    S = zeros(numHands, numPlayersMax);
    parfor i = 1:numPlayers(j);
        S(:, i) = pctdemo_task_blackjack(numHands, 1);
    end  
    
    time(j)=toc;
    speedup= time(1)/time(j);
    text='Ran %d hands in %3.2f seconds using %d players. Speedup factor is %3.2f. \n';    
    fprintf(text,numHandsMax, time(j), numPlayers(j), speedup );
 
end
matlabpool close;